<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;

class CreanceDetteFond extends Model 
{

    protected $table = 'creances_dettes_fonds';
    public $timestamps = true;

    use SoftDeletes;

    protected $dates = ['deleted_at'];
    protected $fillable = array('date', 'slug', 'id_utilisateurNiveau4', 'id_utilisateur', 'id_typeCaisse', 'type', 'montant', 'montantRembourse', 'motif', 'dureeAmortissement', 'dateDebutAmortissement', 'description', 'statut');
    protected $visible = array('date', 'slug', 'id_utilisateurNiveau4', 'id_utilisateur', 'id_typeCaisse', 'type', 'montant', 'montantRembourse', 'motif', 'dureeAmortissement', 'dateDebutAmortissement', 'description', 'statut');

    public function utilisateurNiveau4()
    {
        return $this->belongsTo('App\Models\UtilisateurNiveau4', 'id_utilisateurNiveau4');
    }

    public function utilisateur()
    {
        return $this->belongsTo('App\Models\Utilisateur', 'id_utilisateur');
    }

    public function typeCaisse()
    {
        return $this->belongsTo('App\Models\TypeCaisse', 'id_typeCaisse');
    }

}